clear();
clc();
close all;                                  %Plots schlieen

%KONFIGURATION---------------------------------------------------------------------
Y                   = @(x)   -((1.38198*exp(-(3*(x.^2))/2))/(0.300014-erf(sqrt(3/2)*x)));
dYdX                = @(x,y) (-3*x*y)-(y.^2);
Anfangswert         = 0.5;                  %Anfangswert y0
obereGrenze         = 1.3;                  %Intervall obere Grenze
untereGrenze        = 1.0;                  %Intervall untere Grenze
Quantisierung       = 3;                    %Zerlegung des Intervals in Steigungsnherungen
Korrektorschritte   = 1;
sKommastellenDouble = '%.8f';               %Nachkommastellen, die in einer Berechnung mitgeschleift werden sollen

%INITIALISIERUNG-------------------------------------------------------------------
X_INTERVALLSTUFEN(:)=untereGrenze:(obereGrenze-untereGrenze)/Quantisierung:obereGrenze;
aWERTETABELLE(1,:)=["Xi","Euler","Heun","modifiziertes Euler","RK4","analytisch"];

%BERECHNUNG------------------------------------------------------------------------
for(i=1:1:Quantisierung+1)
    aWERTETABELLE(i+1,1)=num2str(X_INTERVALLSTUFEN(i),sKommastellenDouble);
end
Speicher=funktion_euler_verfahren(dYdX,Anfangswert,obereGrenze,untereGrenze,Quantisierung,sKommastellenDouble);
for(i=1:1:size(Speicher,1))
	aWERTETABELLE(i+1,2)=num2str(Speicher(i),sKommastellenDouble);
end
Speicher=funktion_heun_verfahren(dYdX,Anfangswert,obereGrenze,untereGrenze,Quantisierung,Korrektorschritte,sKommastellenDouble);
for(i=1:1:size(Speicher,1))
	aWERTETABELLE(i+1,3)=num2str(Speicher(i),sKommastellenDouble);
end
Speicher=funktion_modifiziertes_euler_verfahren(dYdX,Anfangswert,obereGrenze,untereGrenze,Quantisierung,sKommastellenDouble);
for(i=1:1:size(Speicher,1))
	aWERTETABELLE(i+1,4)=num2str(Speicher(i),sKommastellenDouble);
end
Speicher=funktion_rk4_verfahren(dYdX,Anfangswert,obereGrenze,untereGrenze,Quantisierung,sKommastellenDouble)
for(i=1:1:size(Speicher,1))
	aWERTETABELLE(i+1,5)=num2str(Speicher(i),sKommastellenDouble);
end
for(i=1:1:Quantisierung+1)
	aWERTETABELLE(i+1,6)=num2str(Y(X_INTERVALLSTUFEN(i)),sKommastellenDouble);
end

%FUNKTIONSPLOT---------------------------------------------------------------------
AnzahlGraphen=5;
xACHSE              = @(x) 0*x;
X(:)=X_INTERVALLSTUFEN(:);
FARBEN(:)=["black","blue","red","green","yellow","cyan","magenta"];
Y_POSITIONIERUNG=(max(str2double(aWERTETABELLE(2:end,2)))-min(str2double(aWERTETABELLE(2:end,2))))/AnzahlGraphen;
for(i=1:1:AnzahlGraphen)
    plot(X,str2double(aWERTETABELLE(2:end,i+1)),'color',char(FARBEN(mod(i,size(FARBEN,2))+1)));
    text(((obereGrenze-untereGrenze)/2)+untereGrenze,min(str2double(aWERTETABELLE(2:end,2)))+(i*Y_POSITIONIERUNG),cellstr(aWERTETABELLE(1,i+1)),'color',char(FARBEN(mod(i,size(FARBEN,2))+1)));
    hold on;
end
plot(X,xACHSE(X),'color','black');
hold on;                                %Warten bis zur Plotausgabe
xlabel('x');
ylabel('y');
grid on;
grid minor;

%PROGRAMMENDE----------------------------------------------------------------------
clearvars -except aWERTETABELLE                  %Workspace aufrumen